#region References

using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;


using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.VAL;

using TABLE = gov.va.med.vbecs.Common.VbecsTables;

#endregion

namespace gov.va.med.vbecs.GUI
{
	#region Header

	//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	//<Developers>
	//	<Developer></Developer>
	//</Developers>
	//<SiteName>Hines OIFO</SiteName>
	//<CreationDate></CreationDate>
	//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	//<summary></summary>

	#endregion

	/// <summary>
	/// Class DlgFinalizeTrwReport
	/// </summary>
	public class DlgFinalizeTrwReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables / Components

		private DataTable _dtReactions;
		private DataTable _dtComments;
		private BOL.PatientTransfusionReaction _patientTransfusionReaction;
		private BOL.PatientTransfusionComment _patientTransfusionComment;
		//
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox grpReactionComments;
		private System.Windows.Forms.TextBox txtDetails;
		private System.Windows.Forms.Label lblDetails;
		private System.Windows.Forms.Label lblComment;
		private System.Windows.Forms.GroupBox grpReactionType;
		private System.Windows.Forms.Label lblMedicalDirector;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.TextBox txtMedicalDirector;
		private System.Windows.Forms.ListBox lbReactionType;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgFinalizeTrwReport));
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpReactionComments = new System.Windows.Forms.GroupBox();
			this.txtDetails = new System.Windows.Forms.TextBox();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblDetails = new System.Windows.Forms.Label();
			this.lblComment = new System.Windows.Forms.Label();
			this.grpReactionType = new System.Windows.Forms.GroupBox();
			this.lbReactionType = new System.Windows.Forms.ListBox();
			this.txtMedicalDirector = new System.Windows.Forms.TextBox();
			this.lblMedicalDirector = new System.Windows.Forms.Label();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpReactionComments.SuspendLayout();
			this.grpReactionType.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(620, 30);
			this.vbecsLogo1.TabIndex = 6;
			this.vbecsLogo1.Title = "Finalize TRW Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 407);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 8;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(542, 390);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 5;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.CancelClick);
			// 
			// grpReactionComments
			// 
			this.grpReactionComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReactionComments.Controls.Add(this.txtDetails);
			this.grpReactionComments.Controls.Add(this.cmbComment);
			this.grpReactionComments.Controls.Add(this.lblDetails);
			this.grpReactionComments.Controls.Add(this.lblComment);
			this.grpReactionComments.Location = new System.Drawing.Point(308, 68);
			this.grpReactionComments.Name = "grpReactionComments";
			this.grpReactionComments.Size = new System.Drawing.Size(308, 316);
			this.grpReactionComments.TabIndex = 3;
			this.grpReactionComments.TabStop = false;
			this.grpReactionComments.Text = "Transfusion Reaction Comments";
			// 
			// txtDetails
			// 
			this.txtDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDetails.Location = new System.Drawing.Point(60, 40);
			this.txtDetails.MaxLength = 1000;
			this.txtDetails.Multiline = true;
			this.txtDetails.Name = "txtDetails";
			this.txtDetails.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtDetails.Size = new System.Drawing.Size(238, 268);
			this.txtDetails.TabIndex = 3;
			this.txtDetails.Text = "";
			this.txtDetails.TextChanged += new System.EventHandler(this.DetailsChanged);
			// 
			// cmbComment
			// 
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.Interval = 500;
			this.cmbComment.Location = new System.Drawing.Point(60, 16);
			this.cmbComment.MaxLength = 80;
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(238, 22);
			this.cmbComment.TabIndex = 1;
			this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.CommentChanged);
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(8, 40);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(100, 20);
			this.lblDetails.TabIndex = 2;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblComment
			// 
			this.lblComment.Location = new System.Drawing.Point(8, 16);
			this.lblComment.Name = "lblComment";
			this.lblComment.Size = new System.Drawing.Size(100, 20);
			this.lblComment.TabIndex = 0;
			this.lblComment.Text = "Comment";
			this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpReactionType
			// 
			this.grpReactionType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpReactionType.Controls.Add(this.lbReactionType);
			this.grpReactionType.Location = new System.Drawing.Point(60, 68);
			this.grpReactionType.Name = "grpReactionType";
			this.grpReactionType.Size = new System.Drawing.Size(244, 316);
			this.grpReactionType.TabIndex = 2;
			this.grpReactionType.TabStop = false;
			this.grpReactionType.Text = "Transfusion Reaction Type";
			// 
			// lbReactionType
			// 
			this.lbReactionType.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lbReactionType.ItemHeight = 14;
			this.lbReactionType.Location = new System.Drawing.Point(8, 16);
			this.lbReactionType.Name = "lbReactionType";
			this.lbReactionType.Size = new System.Drawing.Size(228, 284);
			this.lbReactionType.TabIndex = 0;
			this.lbReactionType.SelectedIndexChanged += new System.EventHandler(this.ReactionChanged);
			// 
			// txtMedicalDirector
			// 
			this.txtMedicalDirector.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtMedicalDirector.Location = new System.Drawing.Point(152, 40);
			this.txtMedicalDirector.Name = "txtMedicalDirector";
			this.txtMedicalDirector.ReadOnly = true;
			this.txtMedicalDirector.Size = new System.Drawing.Size(452, 20);
			this.txtMedicalDirector.TabIndex = 1;
			this.txtMedicalDirector.TabStop = false;
			this.txtMedicalDirector.Text = "";
			// 
			// lblMedicalDirector
			// 
			this.lblMedicalDirector.Location = new System.Drawing.Point(68, 40);
			this.lblMedicalDirector.Name = "lblMedicalDirector";
			this.lblMedicalDirector.Size = new System.Drawing.Size(100, 20);
			this.lblMedicalDirector.TabIndex = 0;
			this.lblMedicalDirector.Text = "Medical Director";
			this.lblMedicalDirector.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(464, 390);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 4;
			this.btnOK.Click += new System.EventHandler(this.OKClick);
			this.btnOK.MouseHover += new System.EventHandler(this.OKHover);
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox1.Controls.Add(this.pictureBox1);
			this.groupBox1.Location = new System.Drawing.Point(3, 32);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(53, 352);
			this.groupBox1.TabIndex = 7;
			this.groupBox1.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 1;
			this.pictureBox1.TabStop = false;
			// 
			// DlgFinalizeTrwReport
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(620, 423);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.txtMedicalDirector);
			this.Controls.Add(this.lblMedicalDirector);
			this.Controls.Add(this.grpReactionType);
			this.Controls.Add(this.grpReactionComments);
			this.hlphelpChm.SetHelpKeyword(this, "Finalize_Print_TRW.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(600, 450);
			this.Name = "DlgFinalizeTrwReport";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Finalize TRW Report";
			this.Controls.SetChildIndex(this.grpReactionComments, 0);
			this.Controls.SetChildIndex(this.grpReactionType, 0);
			this.Controls.SetChildIndex(this.lblMedicalDirector, 0);
			this.Controls.SetChildIndex(this.txtMedicalDirector, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.groupBox1, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.grpReactionComments.ResumeLayout(false);
			this.grpReactionType.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Constructors / Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgFinalizeTrwReport(BOL.PatientTransfusionReaction patientTransfusionReaction)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this._patientTransfusionReaction = patientTransfusionReaction;
			this._patientTransfusionComment = new BOL.PatientTransfusionComment();
			this._patientTransfusionComment.CommentCategoryCode = "TW";
			this._patientTransfusionComment.PatientTransfusionReactionGuid = this._patientTransfusionReaction.PatientTransfusionReactionGuid;

			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Methods

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC078.DlgFinalizeTrwReport());
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			//
			LoadTransfusionReactionTypes();
			this.lbReactionType.SelectedIndex = -1;
			//
			LoadComments();
			//
			LoadMedicalDirectorName();
			//
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.Cancel());
		}

		/// <summary>
		/// LoadTransfusionReactionTypes
		/// </summary>
		private void LoadTransfusionReactionTypes()
		{
			this.lbReactionType.Items.Clear();
			//
			this._dtReactions = BOL.ReferenceData.GetTransfusionReactionTypeList();
			//
			foreach(DataRow dr in this._dtReactions.Rows)
			{
				this.lbReactionType.Items.Add(dr[Common.VbecsTables.TransfusionReactionType.TransfusionReactionTypeText].ToString());
			}
		}

		/// <summary>
		/// LoadComments
		/// </summary>
		private void LoadComments()
		{
			this.cmbComment.Items.Clear();
			//
			this._dtComments = BOL.CannedComment.GetCannedComments("TW");
			//
			foreach(DataRow dr in this._dtComments.Rows)
			{
				this.cmbComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
			}
		}

		/// <summary>
		/// LoadMedicalDirectorName
		/// </summary>
		private void LoadMedicalDirectorName()
		{
			this.txtMedicalDirector.Text = ThisUser.CurrentDivisionRole.Division.MedicalDirectorName;
			this._patientTransfusionReaction.MedicalDirectorName = ThisUser.CurrentDivisionRole.Division.MedicalDirectorName;
		}

		/// <summary>
		/// CommentChanged Event Handler
		/// </summary>
		private void CommentChanged(object sender, System.EventArgs e)
		{
			if ((this.cmbComment.SelectedIndex>-1) && (this.cmbComment.SelectedItem.ToString().ToUpper().Trim() == "OTHER"))
			{
				this.lblDetails.Text = "Details*";
			}
			else
			{
				this.lblDetails.Text = "Details";
			}
			//
			if (this.cmbComment.SelectedIndex>-1)
			{
				this._patientTransfusionComment.CannedCommentGuid = (Guid)(this._dtComments.Rows[this.cmbComment.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid]);
				this.IsDirty = true;
			}
			else
			{
				this._patientTransfusionComment.CannedCommentGuid = Guid.Empty;
			}
			//
			CheckValid();
		}

		/// <summary>
		/// ReactionChanged Event Handler
		/// </summary>
		private void ReactionChanged(object sender, System.EventArgs e)
		{
			if ((this.lbReactionType.SelectedIndex>-1) && (this.lbReactionType.SelectedItem.ToString().ToUpper().Trim().StartsWith("OTHER")))
			{
				this.lblComment.Text = "Comment*";
			}
			else
			{
				this.lblComment.Text = "Comment";
			}
			//
			if (this.lbReactionType.SelectedIndex>-1)
			{
				this._patientTransfusionReaction.TransfusionReactionTypeCode = BOL.TransfusionReactionType.GetTransfusionReactionTypeEnum(Convert.ToChar(this._dtReactions.Rows[this.lbReactionType.SelectedIndex][Common.VbecsTables.PatientTransfusionReaction.TransfusionReactionTypeCode]));
				this.IsDirty = true;
			}
			else
			{
				this._patientTransfusionReaction.TransfusionReactionTypeCode = Common.TransfusionReactionType.Unknown;
			}
			//
			CheckValid();
		}

		/// <summary>
		/// DetailsChanged Event Handler
		/// </summary>
		private void DetailsChanged(object sender, System.EventArgs e)
		{
			this._patientTransfusionComment.PatientTransfusionCommentText = this.txtDetails.Text.Trim();
			this.IsDirty = true;
			CheckValid();
		}

		/// <summary>
		/// CheckValid
		/// </summary>
		private void CheckValid()
		{
			if (this._patientTransfusionReaction.TransfusionReactionTypeCode == Common.TransfusionReactionType.Unknown)
			{
				this.btnOK.EnabledButton = false;
				return;
			}
			if ((this._patientTransfusionReaction.TransfusionReactionTypeCode == Common.TransfusionReactionType.Other) && (this.cmbComment.SelectedIndex < 0))
			{
				this.btnOK.EnabledButton = false;
				return;
			}
			if ((this.cmbComment.SelectedIndex>-1) && (this.cmbComment.SelectedItem.ToString().ToUpper().Trim() == "OTHER") && (this.txtDetails.Text.Trim().Length == 0))
			{
				this.btnOK.EnabledButton = false;
				return;
			}
			//
			this.btnOK.EnabledButton = true;
		}

		/// <summary>
		/// CancelClick Event Handler
		/// </summary>
		private void CancelClick(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		/// <summary>
		/// OKHover Event Handler
		/// </summary>
		private void OKHover(object sender, System.EventArgs e)
		{
			string tooltip = "";
			//
			if (this._patientTransfusionReaction.TransfusionReactionTypeCode == Common.TransfusionReactionType.Unknown)
			{
				tooltip += Common.StrRes.Tooltips.Common.SelectOneItem("reaction type").ResString+"\n";
			}
			if ((this._patientTransfusionReaction.TransfusionReactionTypeCode == Common.TransfusionReactionType.Other) && (this.cmbComment.SelectedIndex<0))
			{
				tooltip += Common.StrRes.Tooltips.UC078.CommentRequired().ResString+"\n";
			}
			if ((this.cmbComment.SelectedIndex>-1) && (this.cmbComment.SelectedItem.ToString().ToUpper().Trim() == "OTHER") && (this.txtDetails.Text.Trim().Length == 0))
			{
				tooltip += Common.StrRes.Tooltips.Common.CommentRequiredWithOther().ResString+"\n";
			}
			//
			if (tooltip.Length==0)
			{
				tooltip = Common.StrRes.Tooltips.UC078.OKToFinalize().ResString;
			}
			//
			this.btnOK.SetToolTip(tooltip);
		}

		/// <summary>
		/// OKClick Event Handler
		/// </summary>
		private void OKClick(object sender, System.EventArgs e)
		{
			DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("finalized TRW report"));
			if (_saveResult != DialogResult.Yes)
			{
				return;
			}
			try
			{
				//
				if (this._patientTransfusionReaction.FinalizeReport(this._patientTransfusionComment, Common.UpdateFunction.UC078DlgFinalizeTrwReport))
				{
					
					#region Dss Extract
					//CR 2298, BR 78.06
					if ( VistALink.IsAvailable )
					{
						// Send reaction data to Dss
						DataTable dt = BOL.PatientTransfusionReaction.GetImplicatedTransfusionRecordsForPatientTransfusionReaction
							( this._patientTransfusionReaction.PatientTransfusionReactionGuid, Common.LogonUser.LogonUserDivisionCode );
						//
						if( dt != null && dt.Rows != null )
						{
							int rowCount = dt.Rows.Count;
							//
							if ( rowCount > 0 )
							{
								for ( int idx = 0; idx < rowCount; idx++ )
								{
									DssExtract.UpdateVistADssExtract( (Guid)dt.Rows[idx][TABLE.PatientTransfusion.PatientTransfusionGuid], UpdateFunction.UC078DlgFinalizeTrwReport );
								}
							}
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.DSSConnectionLost());
					}

					#endregion
					//
					this.IsDirty = false;
					//
					this.DialogResult = DialogResult.OK;
					this.Close();
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.SystemErrorWhileSaving("finalized TRW Report"));
					return;
				}
			}
			catch (Common.RowVersionException)
			{
				this.btnOK.RowVersionException = true;		//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				return;
			}
		}

		#endregion
	}
}

